unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FPipe: THandle;
    FConnected: boolean;
    { Private declarations }
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;

implementation

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.Timer1Timer(Sender: TObject);
var
   _s: string;
   _len: dword;
   _datatoread: integer;
   _ms: TMemoryStream;
   _bl, _tl: integer;
begin
   if not FConnected then
      begin
         { check the connection status }
         if ConnectNamedPipe(FPipe, nil) then
            raise Exception.Create('connect error')
         else
            { do we have a client? }
            if GetLastError = ERROR_PIPE_CONNECTED then
               FConnected:= true
            else
               { are we still waiting for clients }
               if GetLastError <> ERROR_PIPE_LISTENING then
                  raise Exception.Create(SysErrorMessage(GetLastError));
      end;
   if not FConnected then
      exit;
   { check if any data available }
   if not PeekNamedPipe(FPipe, @_datatoread, 4, @_len, @_tl, @_bl) then
      raise Exception.Create(SysErrorMessage(GetLastError));
   if (_len = 0) and (_tl = 0) and (_bl = 0) then
      exit;
   { read the data size }
   if (not ReadFile(FPipe, _datatoread, 4, _len, nil)) or (_len <> 4) then
      raise Exception.Create(SysErrorMessage(GetLastError));
   { read the data }
   SetLength(_s, _datatoread);
   if (not ReadFile(FPipe, _s[1], _datatoread, _len, nil)) or (_len <> _datatoread) then
      raise Exception.Create(SysErrorMessage(GetLastError));
   { create the stream and save it to it }
   _ms:= TMemoryStream.Create;
   try
      { write the msg data }
      _ms.Write(_s[1], length(_s));
      { go to begining of the file }
      _ms.Position:= 0;

      { decode the stream }
      ReceiveData(_ms);
   finally
      _ms.Free;
   end;
end;

procedure TfrmMessageReceiver.FormCreate(Sender: TObject);
var
   _pname: string;
begin
   try
      { build the pipe name }
      _pname:= '\\' + '.' + '\pipe\' + 'testpipe';
      { create the file - pipe }
      FPipe:= CreateNamedPipe(PChar(_pname), PIPE_ACCESS_DUPLEX,
         PIPE_TYPE_MESSAGE or PIPE_READMODE_MESSAGE or PIPE_NOWAIT, PIPE_UNLIMITED_INSTANCES,
			1024, 1024, NMPWAIT_USE_DEFAULT_WAIT, nil);
      { check if we have the pipe }
      if (FPipe = INVALID_HANDLE_VALUE) then
         raise Exception.Create('failed to create the pipe ');
      if ConnectNamedPipe(FPipe, nil) then
         raise Exception.Create('failed to connect the pipe ');
      FConnected:= false;
   except
      on e: exception do
         begin
            showmessage(e.Message);
            Application.Terminate;
         end;
   end;
end;

procedure TfrmMessageReceiver.FormDestroy(Sender: TObject);
begin
   CloseHandle(FPipe);
end;

end.
